/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.MainAppFrame;
import com.quantumdata.busmon.Sniffer;
import com.quantumdata.busmon.parser.BadPacketException;
import com.quantumdata.busmon.parser.FiveVoltSenseDataBlock;
import com.quantumdata.busmon.parser.Packet;
import com.quantumdata.busmon.parser.PacketTrace;
import com.quantumdata.busmon.parser.PacketTraceType;
import com.quantumdata.busmon.parser.Parser;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.IOException;
import java.io.ObjectInput;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTable;

public class HDMIPacketTrace
extends PacketTrace {
    private String[] columnNames = new String[]{"Number", "Err", "Time since Boot", "Delta Time", "Speed (kHz)", "Dir", "Source", "Type", "Details"};
    private static final long serialVersionUID = 1L;

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    public String getNonHtmlColumnName(int n) {
        return this.columnNames[n];
    }

    public HDMIPacketTrace() {
        this.traceType = PacketTraceType.HDMI_PACKET_TRACE_TYPE;
    }

    public HDMIPacketTrace(ObjectInput objectInput) throws ClassNotFoundException, IOException, BadPacketException {
        super(objectInput);
        this.traceType = PacketTraceType.HDMI_PACKET_TRACE_TYPE;
    }

    public String getValueAt(int n, int n2, boolean bl) {
        String string;
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= this.filteredVector.size()) {
            return null;
        }
        Packet packet = (Packet)this.filteredVector.get(n);
        block0 : switch (n2) {
            case 0: {
                string = Integer.toString(packet.getOrdinal());
                break;
            }
            case 1: {
                string = packet.isError() ? "!!!" : "";
                break;
            }
            case 2: {
                string = this.GetTimestampAsString(packet);
                break;
            }
            case 3: {
                if (MainAppFrame.deltaTimeAction.isTrue()) {
                    int n3 = Sniffer.window.jPacketTable.getSelectedRow();
                    if (n3 == -1) {
                        if (n == 0) {
                            string = this.GetTimestampAsString(0L);
                            break;
                        }
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(0));
                        break;
                    }
                    if (n >= n3) {
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3));
                        break;
                    }
                    string = "-" + this.GetTimestampDifferenceAsString((Packet)this.filteredVector.get(n3), packet);
                    break;
                }
                if (n == 0) {
                    string = this.GetTimestampAsString(0L);
                    break;
                }
                string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n - 1));
                break;
            }
            case 4: {
                string = TypeConverter.getSpeedString(packet.getSpeed());
                break;
            }
            case 5: {
                string = packet.getDirection();
                break;
            }
            case 6: {
                switch (packet.getSource()) {
                    case 5: {
                        FiveVoltSenseDataBlock fiveVoltSenseDataBlock = (FiveVoltSenseDataBlock)packet.getDataBlock();
                        string = fiveVoltSenseDataBlock.getSourceName();
                        break block0;
                    }
                }
                string = Packet.getSourceName(packet.getSource());
                break;
            }
            case 7: {
                string = packet.getDescription();
                break;
            }
            case 8: {
                string = packet.getDetails();
                break;
            }
            default: {
                string = "???";
            }
        }
        if (bl) {
            return string;
        }
        if (packet.isError()) {
            string2 = "<html><span style='color:#ff0000;'>";
        } else if (packet.isEDID()) {
            string2 = "<html><span style='color:#808000;'>";
        } else if (packet.isDDCCI()) {
            string2 = "<html><span style='color:#0000c0;'>";
        } else if (packet.isHDCP()) {
            string2 = "<html><span style='color:#00c000;'>";
        } else if (packet.isEvent()) {
            string2 = "<html><span style='color:#008080;'>";
        } else if (packet.isCEC()) {
            string2 = "<html><span style='color:#c000c0;'>";
        }
        stringBuffer.append(string2);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public String GetTimestampAsString(long l) {
        return TypeConverter.getTimestampString(l * 100L);
    }

    public String GetTimestampAsString(Packet packet) {
        return TypeConverter.getTimestampString(packet.getTimestamp() * 100L);
    }

    public String GetTimestampDifferenceAsString(Packet packet, Packet packet2) {
        long l = packet.getTimestamp();
        long l2 = packet2.getTimestamp();
        return TypeConverter.getTimestampString((l - l2) * 100L);
    }

    public void updateTimeColumnName(JTable jTable) {
        if (MainAppFrame.deltaTimeAction.isTrue()) {
            jTable.getColumnModel().getColumn(3).setHeaderValue("Cumulative Time");
        } else {
            jTable.getColumnModel().getColumn(3).setHeaderValue("Delta Time");
        }
    }

    public StringBuffer saveToHtml() {
        int n;
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n<head>\n");
        stringBuffer.append("<title>ACA Program Version 1.41</title>\n");
        stringBuffer.append("<style>\n");
        stringBuffer.append("table{font-weight: bold; font-size: 10px; color: #000000; font-family: verdana, arial, helvetica, sans-serif}\n");
        stringBuffer.append("td{border-style: 1px solid black; }\n");
        stringBuffer.append("td.event{color: black;  background-color: #00C0F7;}\n");
        stringBuffer.append("td.hdcp{color: black;  background-color: #71FFBD;}\n");
        stringBuffer.append("td.edid{color: black;  background-color: #FFD471;}\n");
        stringBuffer.append("td.cec{color: black;  background-color: #D071FF;}\n");
        stringBuffer.append("td.error{color: black;  background-color: #FF0000;}\n");
        stringBuffer.append("td.headerinfoleft{color: white; background-color: #000000;}\n");
        stringBuffer.append("td.headerinforight{border: 1px solid black;}\n");
        stringBuffer.append("th{border-bottom: 1px solid black; color: white; background-color: #000000}\n");
        stringBuffer.append("</style>\n");
        stringBuffer.append("</head>\n");
        stringBuffer.append("<body>\n");
        stringBuffer.append("<table>\n");
        stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">ACA PROGRAM VERSION</td>\n");
        stringBuffer.append("<td class=\"headerinforight\">1.41</td>\n");
        stringBuffer.append("</tr>\n");
        stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">REPORT DATE</td>\n");
        stringBuffer.append("<td class=\"headerinforight\">" + new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z").format(new Date()) + "</td>\n");
        stringBuffer.append("</tr>\n");
        if (Parser.instrument.isConnected()) {
            object = "verf?";
            String string = Parser.instrument.sendCmd((String)object).getResponse();
            String string2 = "verg?";
            String string3 = Parser.instrument.sendCmd(string2).getResponse();
            if (string != null && string.length() > 0) {
                stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">FIRMWARE VERSION</td>\n");
                stringBuffer.append("<td class=\"headerinforight\">" + string + "</td>\n");
                stringBuffer.append("</tr>\n");
            }
            if (string3 != null && string3.length() > 0) {
                stringBuffer.append("<tr>\n<td class=\"headerinfoleft\">GATEWARE VERSION</td>\n");
                stringBuffer.append("<td class=\"headerinforight\">" + string3 + "</td>\n");
                stringBuffer.append("</tr>\n");
            }
        }
        stringBuffer.append("</table>\n<p>\n");
        stringBuffer.append("<table>\n");
        stringBuffer.append("  <tr>\n");
        object = Sniffer.window.jPacketTable;
        int n2 = ((JTable)object).getColumnCount();
        for (n = 0; n < n2; ++n) {
            stringBuffer.append("<th>\n");
            switch (n) {
                case 5: {
                    this.appendNonBreakingSpace(stringBuffer, 15);
                    break;
                }
                case 7: {
                    this.appendNonBreakingSpace(stringBuffer, 5);
                    break;
                }
                case 8: {
                    this.appendNonBreakingSpace(stringBuffer, 30);
                }
            }
            stringBuffer.append(this.getColumnName(n).toUpperCase());
            switch (n) {
                case 5: {
                    this.appendNonBreakingSpace(stringBuffer, 15);
                    break;
                }
                case 7: {
                    this.appendNonBreakingSpace(stringBuffer, 5);
                    break;
                }
                case 8: {
                    this.appendNonBreakingSpace(stringBuffer, 30);
                }
            }
            stringBuffer.append("</th>\n");
        }
        stringBuffer.append("<th align=\"left\">RAW DATA</th>");
        stringBuffer.append("</tr>");
        n = ((JTable)object).getRowCount();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("<tr>\n");
            for (int j = 0; j < n2 + 1; ++j) {
                stringBuffer.append(this.getHtmlDecoratedValue(i, j));
            }
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table></body></html>");
        return stringBuffer;
    }

    private void appendNonBreakingSpace(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("&nbsp;");
        }
    }

    private String getHtmlDecoratedValue(int n, int n2) {
        Packet packet = (Packet)this.filteredVector.get(n);
        String string = "";
        block0 : switch (n2) {
            case 0: {
                string = Integer.toString(packet.getOrdinal());
                break;
            }
            case 1: {
                string = packet.isError() ? "!!!" : "";
                break;
            }
            case 2: {
                string = this.GetTimestampAsString(packet);
                break;
            }
            case 3: {
                if (MainAppFrame.deltaTimeAction.isTrue()) {
                    int n3 = Sniffer.window.jPacketTable.getSelectedRow();
                    if (n3 == -1) {
                        if (n == 0) {
                            string = this.GetTimestampAsString(0L);
                            break;
                        }
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(0));
                        break;
                    }
                    if (n >= n3) {
                        string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n3));
                        break;
                    }
                    string = "-" + this.GetTimestampDifferenceAsString((Packet)this.filteredVector.get(n3), packet);
                    break;
                }
                if (n == 0) {
                    string = this.GetTimestampAsString(0L);
                    break;
                }
                string = this.GetTimestampDifferenceAsString(packet, (Packet)this.filteredVector.get(n - 1));
                break;
            }
            case 4: {
                string = TypeConverter.getSpeedString(packet.getSpeed());
                break;
            }
            case 5: {
                string = packet.getDirection();
                break;
            }
            case 6: {
                switch (packet.getSource()) {
                    case 5: {
                        FiveVoltSenseDataBlock fiveVoltSenseDataBlock = (FiveVoltSenseDataBlock)packet.getDataBlock();
                        string = fiveVoltSenseDataBlock.getSourceName();
                        break block0;
                    }
                }
                string = Packet.getSourceName(packet.getSource());
                break;
            }
            case 7: {
                string = packet.getDescription();
                break;
            }
            case 8: {
                string = packet.getDetails();
                break;
            }
            case 9: {
                string = packet.getHexString();
            }
        }
        String string2 = "";
        StringBuffer stringBuffer = new StringBuffer();
        if (packet.isError()) {
            string2 = "<td class=\"error\">";
        } else if (packet.isEDID()) {
            string2 = "<td class=\"edid\">";
        } else if (packet.isDDCCI()) {
            string2 = "<td class=\"ddcci\">";
        } else if (packet.isHDCP()) {
            string2 = "<td class=\"hdcp\">";
        } else if (packet.isEvent()) {
            string2 = "<td class=\"event\">";
        } else if (packet.isCEC()) {
            string2 = "<td class=\"cec\">";
        }
        stringBuffer.append(string2);
        if (string.length() > 0) {
            stringBuffer.append(string + "</td>\n");
        } else {
            stringBuffer.append("&nbsp;</td>\n");
        }
        return stringBuffer.toString();
    }
}

